import React, { useState } from "react";
import Col from "react-bootstrap/Col";
import Row from "react-bootstrap/Row";
import Toast from "react-bootstrap/Toast";
import "../App.css";
import { EmailPopup, FeedbackModal } from "./Modal";

function Kodi() {
  const [aiSupportConversation, setAiSupportConversation] = useState("");
  const [aiSupportResult, setAiSupportResult] = useState("");
  const [originalResult, setOriginalResult] = useState("");
  const [sourceArea, setSourceArea] = useState("");
  const [buttonStatus, setButtonStatus] = useState("default");
  // 1.default:Make the button enabled for all
  // 2.generating:Disable the button during the process
  // 3.needRating:Disable functional buttons before rating
  const [webLanguage, setWebLanguage] = useState("en-us");
  const [sourceFrom, setSourceFrom] = useState("Strikingly");
  const [responseSubmitted, setResponseSubmitted] = useState(false);
  const [helpType, setHelpType] = useState("");
  const [isCancelled, setIsCancelled] = useState(false);
  const [controller, setController] = useState(null);
  const [copyToast, setCopyToast] = useState(false);
  const [thumbDowntoast, setThumbDownToast] = useState(false);
  const [showFeedbackModal, setShowFeedbackModal] = useState(false); //Control Pop-up Display
  const [url, setUrl] = useState("https://strk-ai-support.ngrok.app");
  // const [url, setUrl] = useState('https://8ac5a21b602f.ngrok.app')
  // const [action, setAction] = useState('Generate')

  const clearMessage = () => {
    setAiSupportConversation("");
    setAiSupportResult("");
    setSourceArea("");
    setButtonStatus("default"); //Make the button enabled for all
  };

  const copyMessage = () => {
    const question = aiSupportConversation;
    let answer = originalResult;
    if (!question || !answer) {
      setAiSupportResult(
        "Please use this button only when you have question and answer in the text area"
      );
      setButtonStatus("default");
    } else {
      if (answer.startsWith("<br><br>")) {
        answer = answer.replace("<br><br>", "");
      }
      // navigator.clipboard.writeText(answer);
      unsecuredCopyToClipboard(answer);
      setCopyToast(true);
      // After copy message to clipboard, we send all the required data to our server
      if (responseSubmitted) {
        // If the response is submitted, we do not send the response to the server again
        setButtonStatus("default");
        return;
      }

      // const sendMessage = (question, answer, type, range, helpAction=null, reasonForEscalation=null)
      sendMessage(question, answer, helpType, "Good");
      sendMessage(question, answer, helpType, "All", "Copy", null);
      setButtonStatus("default");
    }
  };

  const thumbDown = () => {
    setButtonStatus("generating"); //Disable the button during the process
    const question = aiSupportConversation;
    let answer = originalResult;
    if (!question || !answer) {
      setAiSupportResult(
        "Please use this button only when you have question and answer in the text area"
      );
      setButtonStatus("default");
    } else {
      if (answer.startsWith("<br><br>")) {
        answer = answer.replace("<br><br>", "");
      }
      if (responseSubmitted) {
        // If the response is submitted, we do not send the response to the server again
        setButtonStatus("default");
        return;
      }

      setResponseSubmitted(true);
      // const sendMessage = (question, answer, type, range, helpAction=null, reasonForEscalation=null)
      sendMessage(question, answer, helpType, "Bad", null, "Thumb Down");
      sendMessage(question, answer, helpType, "All", "Thumb Down", null);
      setThumbDownToast(true);
      setTimeout(() => {
        setShowFeedbackModal(true);
      }, 1000);
      setButtonStatus("default");
    }
  };

  function unsecuredCopyToClipboard(text) {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    try {
      document.execCommand("copy");
    } catch (err) {
      console.error("Unable to copy to clipboard", err);
    }
    document.body.removeChild(textArea);
  }

  const regenerateResponse = () => {
    const question = aiSupportConversation;
    let answer = originalResult;
    if (!question || !answer) {
      setAiSupportResult(
        "Please use this button only when you have question and answer in the text area"
      );
      setButtonStatus("default");
    } else {
      setButtonStatus("generating"); //Disable the button during the process
      console.log("inside the regenerate, buttonStatus:", buttonStatus);
      const previousCommand = helpType;
      if (previousCommand === "KB") {
        articleHelp("Regenerate");
      } else if (previousCommand === "Template") {
        templateHelp("Regenerate");
      }

      if (answer.startsWith("<br><br>")) {
        answer = answer.replace("<br><br>", "");
      }

      if (responseSubmitted) {
        // If the response is submitted, we do not send the response to the server again
        // setIsDisabled(false);
        return;
      } else {
        // const sendMessage = (question, answer, type, range, helpAction=null, reasonForEscalation=null)
        sendMessage(
          question,
          answer,
          previousCommand,
          "Bad",
          null,
          "Regenerate"
        );
        sendMessage(
          question,
          answer,
          previousCommand,
          "All",
          "Regenerate",
          null
        );
        setButtonStatus("generating"); //Disable the button during the process
      }
      // setIsDisabled(true);
      setButtonStatus("default");
    }
  };

  const cancelStreaming = () => {
    setIsCancelled(true);
    if (controller) {
      controller.abort();
    }
    setButtonStatus("default");
  };

  const sendMessage = (
    question,
    answer,
    type,
    range,
    helpAction = null,
    reasonForEscalation = null
  ) => {
    const storedEmail = localStorage.getItem("email");
    const timestamp = new Date();
    const options = { timeZone: "Asia/Shanghai" };
    const date = timestamp.toLocaleDateString("en-US", options); // Get date in format mm/dd/yy
    const time = timestamp.toLocaleTimeString("en-US", options); // Get time in format hh:mm:ss
    const dateTime = `${date} ${time} UTC+8`; // Combine date and time into one string
    const feedbackData = {
      email: storedEmail,
      time: dateTime,
      type: type,
      language: webLanguage,
      question: question,
      answer: answer,
      range: range,
      reasonForEscalation: reasonForEscalation,
      action: helpAction,
    };

    console.log(feedbackData);

    const apiUrl = `${url}/v1/ai-support/feedbacks`;
    fetch(apiUrl, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(feedbackData),
    })
      .then((response) => {
        if (response.ok) {
          return response.json();
        } else {
          throw "some error text";
        }
      })
      .then((data) => {
        console.log(data);
        if (range !== "All" && helpAction !== "Regenerate") {
          setResponseSubmitted(true);
        }
      })
      .catch((error) => {
        setButtonStatus("default");
        setAiSupportResult(
          "Error. Try again later. If the error persists, please contact the developer."
        );
        console.error("Request failed:", error);
      });
  };

  const articleHelp = async (helpAction = "Generate") => {
    setIsCancelled(false);
    setHelpType("KB");
    const abortController = new AbortController();
    setController(abortController); // create a new abort controller
    setButtonStatus("generating"); //Disable the button during the process
    console.log(webLanguage);
    setSourceArea("");
    const chat = aiSupportConversation;
    if (!chat) {
      setAiSupportResult(
        "Please provide question in the Message box on the left"
      );
      setButtonStatus("default");
    } else {
      // setIsStreaming(true)
      setAiSupportResult("");
      console.log(webLanguage);
      const data = {
        message: chat,
        language: webLanguage,
        source: sourceFrom,
      };
      try {
        const apiUrl = `${url}/v1/ai-support/article-support`;
        const response = await fetch(apiUrl, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(data),
          signal: abortController.signal,
          timeout: 20000,
        });

        if (!response.ok) {
          throw await response.json(); // Throw the error response from the server
        }

        const reader = response.body.getReader();
        const decoder = new TextDecoder();

        let message = "";
        let htmlMessage = "";
        let responseText = "";
        let plainResponse = "";
        while (true) {
          const { done, value } = await reader.read();
          if (done || isCancelled) break;
          message = decoder.decode(value, { stream: true });

          if (message.includes("Source: (Internal-only)")) {
            let source = message;
            setSourceArea(source);
          } else {
            plainResponse += message;
            htmlMessage = message.replace(/\n/g, "<br>");
            responseText += htmlMessage;
            setAiSupportResult(responseText);
          }
        }

        setOriginalResult(plainResponse);

        // const sendMessage = (question, answer, type, range, helpAction=null, reasonForEscalation=null)
        sendMessage(chat, plainResponse, "KB", "All", helpAction, null);

        setResponseSubmitted(false);
        setButtonStatus("needRating"); //Disable functional buttons before rating
      } catch (error) {
        setButtonStatus("default");
        setIsCancelled(false);
        if (error.name !== "AbortError") {
          setAiSupportResult(
            "Error. Try again later. If the error persists, please contact the developer."
          );
          console.error("Request failed:", error.error);
          sendMessage(chat, error.error, "KB", "All", helpAction, null);
        }
      }
    }
  };

  function renderSourceArea() {
    const urlRegex = /(https?:\/\/[^\s]+)/g;
    const urls = sourceArea.match(urlRegex);
    let replacedSourceArea = sourceArea;

    if (urls) {
      urls.forEach((url) => {
        const urlHtml = `<a href="${url}" target="_blank">${url}</a>`;
        replacedSourceArea = replacedSourceArea.replace(url, urlHtml);
      });
    }

    replacedSourceArea = replacedSourceArea.replace(/\n/g, "<br>");

    return replacedSourceArea;
  }

  const templateHelp = async (helpAction = "Generate") => {
    setIsCancelled(false);
    setHelpType("Template");
    const abortController = new AbortController();
    setController(abortController); // create a new abort controller
    setButtonStatus("generating");
    setSourceArea("");

    const chat = aiSupportConversation;
    if (!chat) {
      console.log("No chat");
      setAiSupportResult(
        "Please provide question in the Message box on the left"
      );
      setButtonStatus("default");
    } else {
      console.log(chat);
      // setIsStreaming(true)
      setAiSupportResult("");

      const data = {
        message: chat,
        language: webLanguage,
        source: sourceFrom,
      };

      try {
        const apiUrl = `${url}/v1/ai-support/template-recommendation`;
        const response = await fetch(apiUrl, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(data),
          signal: abortController.signal,
          timeout: 20000,
        });

        if (!response.ok) {
          throw await response.json(); // Throw the error response from the server
        }

        const reader = response.body.getReader();
        const decoder = new TextDecoder();

        let message = "";
        let htmlMessage = "";
        let responseText = "";
        let plainResponse = "";
        while (true) {
          const { done, value } = await reader.read();
          if (done || isCancelled) break;
          message = decoder.decode(value, { stream: true });
          // if (message.trim() !== "Template")
          // {
          //   plainResponse += message
          // }
          plainResponse += message;

          htmlMessage = message.replace(/\n/g, "<br>");
          // if (htmlMessage.trim() !== "Template")
          // {
          //   responseText += htmlMessage
          // }
          responseText += htmlMessage;

          setAiSupportResult(responseText);
        }

        setOriginalResult(plainResponse);

        const regex = /(https?:\/\/[^\s\]]+\.[^\s\]]+)(?=[\n<\]])/g;

        let modifiedText = plainResponse.replace(
          regex,
          '<a href="$1" target="_blank">$1</a>'
        );

        modifiedText = modifiedText.replace(/\n/g, "<br>");

        setAiSupportResult(modifiedText);

        // const sendMessage = (question, answer, type, range, helpAction=null, reasonForEscalation=null)
        sendMessage(chat, plainResponse, "Template", "All", helpAction, null);

        setResponseSubmitted(false);
        setButtonStatus("needRating"); //Disable functional buttons before rating
        setSourceArea("");
      } catch (error) {
        setIsCancelled(false);
        setButtonStatus("default");
        if (error.name !== "AbortError") {
          setAiSupportResult(
            "Error. Try again later. If the error persists, please contact the developer."
          );
          console.error("Request failed:", error.error);
          sendMessage(chat, error.error, "Template", "All", helpAction, null);
        }
      }
    }
  };

  const handleDivClick = (event) => {
    if (event.target.tagName === "A") {
      // handle hyperlink click event
      window.open(event.target.href);
      event.preventDefault();
    }
  };

  const handleLanguageChange = (event) => {
    console.log("function called");
    console.log(event.target.value);
    const language = event.target.value;
    setWebLanguage(language);
  };

  const handleSourceSelect = (event) => {
    console.log("function called");
    console.log(event.target.value);
    const template = event.target.value;
    setSourceFrom(template);
  };

  function AutohideCopyToast() {
    return (
      <Col>
        <Col xs={12} className="mb-2">
          <button
            id="copyButton"
            className="btn btn-success"
            onClick={copyMessage}
            disabled={buttonStatus === "generating"}
          >
            Copy Good Response
          </button>
        </Col>
        <Col xs={12}>
          <Toast
            onClose={() => setCopyToast(false)}
            show={copyToast}
            delay={1500}
            autohide
          >
            <Toast.Body>Response copied successfully</Toast.Body>
          </Toast>
        </Col>
      </Col>
    );
  }

  function AutohideThumbDownToast() {
    return (
      <Row>
        <Col xs={12} className="mb-2">
          <button
            id="thumbDown"
            className="btn btn-warning mt-1"
            onClick={thumbDown}
            disabled={buttonStatus === "generating"}
          >
            <span class="bi bi-hand-thumbs-down"></span> Thumb Down
          </button>
        </Col>
        <Col xs={12}>
          <Toast
            onClose={() => setThumbDownToast(false)}
            show={thumbDowntoast}
            delay={500}
            autohide
          >
            <Toast.Body>Thumb Down feedback sent</Toast.Body>
          </Toast>
        </Col>
        <FeedbackModal
          showFeedbackModal={showFeedbackModal}
          onClose={() => setShowFeedbackModal(false)}
        />
      </Row>
    );
  }

  const handleMouseDown = (event) => {
    event.preventDefault();
  };

  const handleSelectStart = (event) => {
    event.preventDefault();
  };

  const handleDragStart = (event) => {
    event.preventDefault();
  };

  return (
    <div className="container-fluid App" style={{ marginTop: "10px" }}>
      <div className="col">
        <div className="row-md-2">
          <div className="row">
            <div className="col-md-3">
              <div className="float-right" style={{ marginTop: "10px" }}>
                <div className="form-floating">
                  <select
                    className="form-control"
                    id="webLanguageSelect"
                    defaultValue="en-us"
                    onChange={handleLanguageChange}
                  >
                    <option value="en-us">English (US)</option>
                    <option value="ar">العربية</option>
                    <option value="cs">Čeština</option>
                    <option value="de-de">Deutsch (Deutschland)</option>
                    <option value="es">Español</option>
                    <option value="fi">Suomi</option>
                    <option value="fr">Français</option>
                    <option value="id">Bahasa Indonesia</option>
                    <option value="it">Italiano</option>
                    <option value="ja">日本語</option>
                    <option value="nl-nl">Nederlands (Nederland)</option>
                    <option value="no">Norsk</option>
                    <option value="pl">Polski</option>
                    <option value="pt-pt">Português (Portugal)</option>
                    <option value="ro">Română</option>
                    <option value="sk">Slovenčina</option>
                    <option value="sv">svenska</option>
                    <option value="vi">Tiếng Việt</option>
                    <option value="zh-cn">简体中文</option>
                    <option value="zh-tw">繁體中文</option>
                  </select>
                  <label htmlFor="webLanguageSelect">
                    Web Language (For KB sources)
                  </label>
                </div>
              </div>
            </div>
            <div className="col-md-2">
              <div className="float-right" style={{ marginTop: "10px" }}>
                <div className="form-floating">
                  <select
                    className="form-control"
                    id="SourceSelect"
                    defaultValue="Strikingly"
                    onChange={handleSourceSelect}
                  >
                    <option value="Strikingly">Strikingly.com</option>
                    <option value="sxl">sxl.cn</option>
                  </select>
                  <label htmlFor="SourceSelect">Sources From</label>
                </div>
              </div>
            </div>

            <div
              className="col-md-6"
              style={{ position: "fixed", top: "0", right: "0" }}
            >
              <button
                className="btn btn-warning"
                onClick={() => setShowFeedbackModal(true)}
              >
                Enter Feedback
              </button>
              <FeedbackModal
                showFeedbackModal={showFeedbackModal}
                onClose={() => setShowFeedbackModal(false)}
              />
            </div>

            <div
              className="col-md-2"
              style={{ position: "fixed", top: "0", right: "0" }}
            >
              <EmailPopup />
            </div>
          </div>
        </div>
        <div className="row-md-10">
          <div
            class="container-fluid"
            className="main"
            style={{ marginTop: "10px" }}
          >
            <div class="row">
              <div class="col-md-5">
                <div class="form-floating">
                  <textarea
                    class="form-control"
                    id="aiSupportConversation"
                    value={aiSupportConversation}
                    onChange={(e) => setAiSupportConversation(e.target.value)}
                    style={{ height: "600px", textAlign: "left" }}
                  ></textarea>
                  <label for="aiSupportConversation">Message</label>
                </div>
              </div>
              <div class="col-md-2">
                <div class="mb-4">
                  <button
                    className="btn btn-primary"
                    onClick={() => templateHelp("Generate")}
                    disabled={
                      buttonStatus === "generating" ||
                      buttonStatus === "needRating"
                    }
                  >
                    Kodi - Template
                  </button>
                </div>
                <div class="mb-4">
                  <button
                    id="aiArticleButton"
                    className="btn btn-primary"
                    onClick={() => articleHelp("Generate")}
                    disabled={
                      buttonStatus === "generating" ||
                      buttonStatus === "needRating"
                    }
                  >
                    Kodi - Support
                  </button>
                </div>
                <div class="mb-4">
                  <button
                    id="clearMessageButton"
                    class="btn btn-primary"
                    onClick={clearMessage}
                    disabled={
                      buttonStatus === "generating" ||
                      buttonStatus === "needRating"
                    }
                  >
                    Clear Message
                  </button>
                </div>
                <div class="mb-3">
                  <button
                    id="cancelButton"
                    className="btn btn-secondary"
                    onClick={cancelStreaming}
                    disabled={buttonStatus !== "generating"}
                  >
                    {" "}
                    Cancel{" "}
                  </button>
                </div>
                <div class="mb-3">
                  <div class="spacer"></div>
                </div>
                <div class="mb-4">
                  <AutohideCopyToast />
                </div>
                <div class="mb-4">
                  <button
                    id="regenerateButton"
                    className="btn btn-warning"
                    onClick={regenerateResponse}
                    disabled={buttonStatus === "generating"}
                  >
                    Regenerate
                  </button>
                </div>
                <div class="mb-1">
                  <AutohideThumbDownToast />
                </div>
              </div>
              <div class="col-md-5">
                <div class="form-floating">
                  <div
                    class="form-control"
                    contentEditable="true"
                    id="aiSupportResult"
                    style={{
                      height: "auto",
                      minHeight: "600px",
                      textAlign: "left",
                    }}
                    dangerouslySetInnerHTML={{ __html: aiSupportResult }}
                    onClick={handleDivClick}
                    onMouseDown={handleMouseDown}
                    onSelectStart={handleSelectStart}
                    onDragStart={handleDragStart}
                  ></div>
                  <label for="aiSupportResult">Response</label>
                </div>
                <div
                  id="sourceArea"
                  style={{ textAlign: "left" }}
                  dangerouslySetInnerHTML={{ __html: renderSourceArea() }}
                ></div>

                {/* <div class="mb-1">
                  <button id="regenerateButton" className="btn btn-warning" onClick={regenerateResponse} disabled={isDisabled} >Regenerate</button>
                </div> */}
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default Kodi;
