# TypeScript

## varibale

```js

// boolean
let createdByNewBoolean: Boolean = new Boolean(1);
let createdByBoolean: boolean = Boolean(1);

// number
let decLiteral: number = 6;
let octalLiteral: number = 0o744;   // 八进制
var notANumber = NaN;

// string
let myName: string = 'test'

// undefined and null
let u: undefined = undefined;
let n: null = null;
let num: number = undefined;    // 为其他类型的子类型

// any 允许被赋值为任何类型， default
let myFavoriteNumber: any = 'seven';
myFavoriteNumber = 7;

// union types
let myFavoriteNumber: string | number;


```

## interfaces

```js
interface Person {
  readonly id: number;      // 只能在创建的时候被赋值，不能再改了
  name: string;
  age?: number;   // ？ 可选属性
  [propName: string]: any;   // 任意属性，（确定属性及可选属性需为其子属性）
}

let gy: Person {
  name: 'gy',
  age?: 23,
}

```

## array

```js
let fibonacci: number[] = [1, 1, 3];
let strnacci: string[] = ['1', '2', '3'];

// Generic 范型
let fib: Array<number> = [1, 2, 3, 4, 5];

// use Interface
interface  NumberArr {
  [index: number]: number
}
let test: NumberArr = [1, 2, 3, 4, 5];

// 任意类型
let list: any[] = ['test', 1];
```

## function

```js
// function declaration
function sum(x: number, y:number): number {
  return x + y;
}

// function expression
var sum: (x: number, y: number) => number = function(x: number, y: number): number {
  return x + y;
}

// or use interface
interface SearchFuc {
  (source: string, subString: string): boolean;
}

let search: SearchFuc;
search = function(source: string, subString: string) {
  return source.search(subString) !== -1;
}

// 可选参数
function sum(a: number, b: number, c?: number) {
  if (c) {
    return a + b + c;
  }
  return a + b;
}
```

## assert

```js
// 类型断言
<类型>值
值 as 类型
```

## 声明文件

```js
// 当使用第三方库时，我们需要引用它的声明文件，通常将其所有声明文件放入单独的文件中

// jQuery.d.ts
declare var jQuery: (string) => any;

// 在使用的文件中，使用三「三斜线」 表明引用的声明文件
/// <reference path='./jQuery.d.ts'></reference>

// 使用工具
@types
npm install @types/jquery --save-dev

```

## 内置对象

```js
// Boolean, Error, Date, RegExp
let b: Boolean = new Boolean(1);
let e: Error = new Error('Error occurred');
let d: Date = new Date();
let r: RegExp = /[a-z]/;


// DOM and BOM
Document, HTMLElement, Event, NodeList
let body: HTMLElement = document.body;
let allDiv: NodeList = document.querySelectorAll('div');
document.addEventListener('click',function(e: MouseEvent)) {
  // do sth
}
```

## 类型别名

```js
type Name = string;
type NameResolver = () => string;
type NameOrResolver = Name | NameResolver;
function getName(n: NameOrResolver): Name {
  if (typeof n === 'string') {
    return n
  } else {
    return n();
  }
}

```

## 字符串字面量类型

```js
type EventNames = 'click' | 'scroll' | 'mousemover';
function handleEvent(ele: Element, event: EventNames) {
  // do sth
}

handleEvent(ele, 'scroll');
handleEvent(ele, 'click');
```

## enum

```js
enum Days {a, b, c, d, e, f, g}
```