window.ComponentAPI = {
  NAME: {
    audio: [
      {
        insertText: 'src="{{src}}"',
        documentation: '音频资源地址',
        label: 'src',
        kind: 9
      },
      {
        insertText: 'loop="{{false}}"',
        documentation: '是否循环播放',
        label: 'loop',
        kind: 9
      },
      {
        insertText: 'controls="{{false}}"',
        documentation: '是否显示默认控件',
        label: 'controls',
        kind: 9
      },
      {
        insertText: 'poster="{{poster}}"',
        documentation: '默认控件上的音频封面的图片资源地址',
        label: 'poster',
        kind: 9
      },
      {
        insertText: 'name="{{name}}"',
        documentation: '默认控件上的音频名字',
        label: 'name',
        kind: 9
      },
      {
        insertText: 'author="{{author}}"',
        documentation: '默认控件上的作者名字',
        label: 'author',
        kind: 9
      },
      {
        insertText: 'bindplay="{{EventHandle}}"',
        documentation: '音频开始播放事件',
        label: 'bindplay',
        kind: 9
      },
      {
        insertText: 'bindpause="{{EventHandle}}"',
        documentation: '音频暂停播放事件',
        label: 'bindpause',
        kind: 9
      },
      {
        insertText: 'bindeneded="{{EventHandle}}"',
        documentation: '音频播放结束事件',
        label: 'bindended',
        kind: 9
      },
      {
        insertText: 'binderror="{{EventHandle}}"',
        documentation: '音频错误事件',
        label: 'binderror',
        kind: 9
      },
      {
        insertText: 'bindtimeupdate="{{EventHandle}}"',
        documentation: '音频播放进度改变事件',
        label: 'bindtimeupdate',
        kind: 9
      }
    ],
    button: [
      {
        insertText: 'size="{{default}}"',
        documentation: '尺寸',
        label: 'size',
        kind: 9
      },
      {
        insertText: 'type="{{default}}"',
        documentation: '类型',
        label: 'type',
        kind: 9
      },
      {
        insertText: 'plain',
        documentation: '是否镂空（背景色透明）',
        label: 'plain',
        kind: 9
      },
      {
        insertText: 'disabled',
        documentation: '是否禁用',
        label: 'disabled',
        kind: 9
      },
      {
        insertText: 'loading',
        documentation: '名称前是否带 loading 图标',
        label: 'loading',
        kind: 9
      },
      {
        insertText: 'form-type="{{submit}}"',
        documentation: '用于 <form/> 组件，点击分别会触发 submit/reset 事件',
        label: 'form-type',
        kind: 9
      },
      {
        insertText: 'open-type="{{share}}"',
        documentation: '微信开放能力',
        label: 'open-type',
        kind: 9
      },
      {
        insertText: 'hover-class="{{String}}"',
        documentation: '被按下时的样式类',
        label: 'hover-class',
        kind: 9
      },
      {
        insertText: 'hover-start-time="{{Number}}"',
        documentation: '按住后多久出现点击态',
        label: 'hover-start-time',
        kind: 9
      },
      {
        insertText: 'hover-stay-time="{{Number}}"',
        documentation: '手指松开后点击态保留时间',
        label: 'hover-stay-time',
        kind: 9
      }
    ],
    canvas: [
      {
        insertText: 'canvas-id="{{String}}"',
        documentation: 'canvas 组件的唯一标识符',
        label: 'canvas-id',
        kind: 9
      },
      {
        insertText: 'disable-scroll',
        documentation: '当在 canvas 中移动时，禁止屏幕滚动以及下拉刷新',
        label: 'disable-scroll',
        kind: 9
      },
      {
        insertText: 'bindtouchstart="{{EventHandle}}"',
        documentation: '手指触摸动作开始',
        label: 'bindtouchstart',
        kind: 9
      },
      {
        insertText: 'bindtouchmove="{{EventHandle}}"',
        documentation: '手指触摸后移动',
        label: 'bindtouchmove',
        kind: 9
      },
      {
        insertText: 'bindtouchend="{{EventHandle}}"',
        documentation: '手指触摸动作结束',
        label: 'bindtouchend',
        kind: 9
      },
      {
        insertText: 'bindtouchcancel="{{EventHandle}}"',
        documentation: '手指触摸动作被打断，如来电提醒，弹窗',
        label: 'bindtouchcancel',
        kind: 9
      },
      {
        insertText: 'binderror="{{EventHandle}}"',
        documentation:
          "当发生错误时触发 error 事件，detail = {errMsg: 'something wrong'}",
        label: 'binderror',
        kind: 9
      },
      {
        insertText: 'bindlongtap="{{EventHandle}}"',
        documentation:
          '手指长按 500ms 之后触发，触发了长按事件后进行移动不会触发屏幕的滚动',
        label: 'bindlongtap',
        kind: 9
      }
    ],
    'checkbox-group': [
      {
        insertText: 'bindchange="{{EventHandle}}"',
        documentation: '值改变时触发的事件',
        label: 'bindchange',
        kind: 9
      }
    ],
    checkbox: [
      {
        insertText: 'value="{{String}}"',
        documentation: '标识值',
        label: 'value',
        kind: 9
      },
      {
        insertText: 'disabled',
        documentation: '是否禁用',
        label: 'disabled',
        kind: 9
      },
      {
        insertText: 'checked',
        documentation: '是否选中',
        label: 'checked',
        kind: 9
      }
    ],
    'contact-button': [
      {
        insertText: 'size="{{36}}"',
        documentation: '尺寸',
        label: 'size',
        kind: 9
      },
      {
        insertText: 'session-from="{{String}}"',
        documentation: '回话来源',
        label: 'session-from',
        kind: 9
      },
      {
        insertText: 'type="{{default-dark}}"',
        documentation: '类型',
        label: 'type',
        kind: 9
      }
    ],
    form: [
      {
        insertText: 'report-submit',
        documentation: '是否返回formId用于发送模板消息',
        label: 'report-submit',
        kind: 9
      },
      {
        insertText: 'bindsubmit="{{EventHandle}}"',
        documentation: '表单提交时触发的事件',
        label: 'bindsubmit',
        kind: 9
      },
      {
        insertText: 'bindreset="{{EventHandle}}"',
        documentation: '表单重置时触发的事件',
        label: 'bindreset',
        kind: 9
      },
      {
        insertText: 'bindreset="{{EventHandle}}"',
        documentation: '自动填写表单时触发',
        label: 'bindautofill',
        kind: 9
      }
    ],
    icon: [
      {
        insertText: 'type="{{String}}"',
        documentation: '类型',
        label: 'type',
        kind: 9
      },
      {
        insertText: 'size="{{23}}"',
        documentation: '尺寸',
        label: 'size',
        kind: 9
      },
      {
        insertText: 'color="{{Color}}"',
        documentation: '颜色',
        label: 'color',
        kind: 9
      }
    ],
    image: [
      {
        insertText: 'src="{{src}}"',
        documentation: '图片资源地址',
        label: 'src',
        kind: 9
      },
      {
        insertText: 'mode="{{scaleToFill}}"',
        documentation: '图片裁剪，缩放模式',
        label: 'mode',
        kind: 9
      },
      {
        insertText: 'bindload="{{EventHandle}}"',
        documentation: '图片载入完毕回调',
        label: 'bindload',
        kind: 9
      },
      {
        insertText: 'binderror="{{EventHandle}}"',
        documentation: '图片载入错误回调',
        label: 'binderror',
        kind: 9
      }
    ],
    input: [
      {
        insertText: 'maxlength="{{Number}}"',
        documentation: '最大输入长度',
        label: 'maxlength',
        kind: 9
      },
      {
        insertText: 'auto-focus',
        documentation: '自动聚焦',
        label: 'auto-focus',
        kind: 9
      },
      {
        insertText: 'focus="{{Boolean}}"',
        documentation: '设置聚焦',
        label: 'focus',
        kind: 9
      },
      {
        insertText: 'placeholder="{{String}}"',
        documentation: '占位符',
        label: 'placeholder',
        kind: 9
      },
      {
        insertText: 'placeholder-style="{{String}}"',
        documentation: '占位符样式',
        label: 'placeholder-style',
        kind: 9
      },
      {
        insertText: 'placeholder-class="{{String}}"',
        documentation: '占位符样式类',
        label: 'placeholder-class',
        kind: 9
      },
      {
        insertText: 'type="{{text}}"',
        documentation: '输入框类型',
        label: 'type',
        kind: 9
      },
      {
        insertText: 'password',
        documentation: '是否为密码输入框',
        label: 'password',
        kind: 9
      },
      {
        insertText: 'auto-fill="{{String}}"',
        documentation: '是否开启自动填写',
        label: 'auto-fill',
        kind: 9
      },
      {
        insertText: 'bindinput="{{EventHandle}}"',
        documentation: '用户输入时触发',
        label: 'bindinput',
        kind: 9
      },
      {
        insertText: 'bindblur="{{EventHandle}}"',
        documentation: '输入框失去焦点时调用',
        label: 'bindblur',
        kind: 9
      },
      {
        insertText: 'bindfocus="{{EventHandle}}"',
        documentation: '输入框聚焦时调用',
        label: 'bindfocus',
        kind: 9
      },
      {
        insertText: 'cursor-spacing="{{Number}}"',
        documentation: '光标与键盘之间的间距',
        label: 'cursor-spacing',
        kind: 9
      },
      {
        insertText: 'bindconfirm="{{EventHandle}}"',
        documentation: '键盘点击完成时触发',
        label: 'bindconfirm',
        kind: 9
      }
    ],
    label: [
      {
        insertText: 'for="{{String}}"',
        documentation: '被绑定控件的id',
        label: 'for',
        kind: 9
      }
    ],
    map: [
      {
        insertText: 'longitude="{{Number}}"',
        documentation: '中心经度',
        label: 'longitude',
        kind: 9
      },
      {
        insertText: 'latitude="{{Number}}"',
        documentation: '中心纬度',
        label: 'latitude',
        kind: 9
      },
      {
        insertText: 'scale="{{Number}}"',
        documentation: '缩放级别',
        label: 'scale',
        kind: 9
      },
      {
        insertText: 'markers="{{Array}}"',
        documentation: '标记点',
        label: 'markers',
        kind: 9
      },
      {
        insertText: 'include-points="{{Array}}"',
        documentation: '将地图缩放以至于都够完整展示所有给定的坐标点',
        label: 'include-points',
        kind: 9
      },
      {
        insertText: 'polyline="{{Array}}"',
        documentation: '在某个地图画线，可用于显示两点之间的路线',
        label: 'polyline',
        kind: 9
      },
      {
        insertText: 'circles="{{Array}}"',
        documentation: '在某个地图以某点为中心画圆',
        label: 'circles',
        kind: 9
      },
      {
        insertText: 'controls="{{Array}}"',
        documentation: '在地图上添加控件，控件不随着地图移动',
        label: 'controls',
        kind: 9
      },
      {
        insertText: 'show-location',
        documentation: '显示当前定位位置的图标',
        label: 'show-location',
        kind: 9
      },
      {
        insertText: 'bindmarkertap="{{EventHandle}}"',
        documentation: '点击marker触发',
        label: 'bindmarkertap',
        kind: 9
      },
      {
        insertText: 'bindcontroltap="{{EventHandle}}"',
        documentation: '点击control触发',
        label: 'bindcontroltap',
        kind: 9
      },
      {
        insertText: 'bindregionchange="{{EventHandle}}"',
        documentation: '地图视野变化时触发',
        label: 'bindregionchange',
        kind: 9
      },
      {
        insertText: 'bindtap="{{EventHandle}}"',
        documentation: '点击地图时触发',
        label: 'bindtap',
        kind: 9
      }
    ],
    navigator: [
      {
        insertText: 'url="{{url}}"',
        documentation: '应用内的跳转链接',
        label: 'url',
        kind: 9
      },
      {
        insertText: 'redirect',
        documentation: '是否关闭当前页面',
        label: 'redirect',
        kind: 9
      },
      {
        insertText: 'open-type="{{type}}"',
        documentation: '跳转类型',
        label: 'open-type',
        kind: 9
      },
      {
        insertText: 'delta="{{Number}}"',
        documentation: '回退的层数，当 open-type="navigateBack"时有效',
        label: 'delta',
        kind: 9
      },
      {
        insertText: 'hover-class="{{className}}"',
        documentation:
          '指定点击时的样式类，当hover-class="none"时，没有点击态效果',
        label: 'hover-class',
        kind: 9
      },
      {
        insertText: 'hover-start-time="{{Number}}"',
        documentation: '按住后多久出现点击态',
        label: 'hover-start-time',
        kind: 9
      },
      {
        insertText: 'hover-stay-time="{{Number}}"',
        documentation: '手指松开后点击态保留时间',
        label: 'hover-stay-time',
        kind: 9
      }
    ],
    'picker-view': [
      {
        insertText: 'indicator-style="{{String}}"',
        documentation: '设置选择器中间选中框的样式',
        label: 'indicator-style',
        kind: 9
      },
      {
        insertText: 'bindchange="{{EventHandle}}"',
        documentation: '当滚动选择，value 改变时触发 change 事件',
        label: 'bindchange',
        kind: 9
      },
      {
        insertText: 'value="{{Array}}"',
        documentation: '指定选择内容',
        label: 'value',
        kind: 9
      }
    ],
    picker: [
      {
        insertText: 'mode="{{selector}}"',
        documentation: '类型',
        label: 'mode',
        kind: 9
      },
      {
        insertText: 'fields="{{day}}"',
        documentation: '日期选择器的选择范围',
        label: 'fields',
        kind: 9
      },
      {
        insertText: 'start="{{String}}"',
        documentation: '时间或日期的开始范围',
        label: 'start',
        kind: 9
      },
      {
        insertText: 'end="{{String}}"',
        documentation: '时间或日期的结束范围',
        label: 'end',
        kind: 9
      },
      {
        insertText: 'disabled',
        documentation: '是否禁用',
        label: 'disabled',
        kind: 9
      },
      {
        insertText: 'auto-fill="{{String}}"',
        documentation: '是否开启自动填写',
        label: 'auto-fill',
        kind: 9
      }
    ],
    progress: [
      {
        insertText: 'percent="{{Number}}"',
        documentation: '百分比0~100',
        label: 'percent',
        kind: 9
      },
      {
        insertText: 'show-info',
        documentation: '在进度条右侧显示百分比',
        label: 'show-info',
        kind: 9
      },
      {
        insertText: 'stroke-width="{{6}}"',
        documentation: '进度条线的宽度，单位px',
        label: 'stroke-width',
        kind: 9
      },
      {
        insertText: 'color="{{#09BB07}}"',
        documentation: '进度条颜色',
        label: 'color',
        kind: 9
      },
      {
        insertText: 'active',
        documentation: '进度条从左往右的动画',
        label: 'active',
        kind: 9
      }
    ],
    'radio-group': [
      {
        insertText: 'bindchange="{{EventHandle}}"',
        documentation: '值改变时触发的事件',
        label: 'bindchange',
        kind: 9
      }
    ],
    radio: [
      {
        insertText: 'value="{{String}}"',
        documentation: '标识值',
        label: 'value',
        kind: 9
      },
      {
        insertText: 'disabled',
        documentation: '是否禁用',
        label: 'disabled',
        kind: 9
      },
      {
        insertText: 'checked',
        documentation: '是否选中',
        label: 'checked',
        kind: 9
      }
    ],
    'scroll-view': [
      {
        insertText: 'scroll-x',
        documentation: '允许横向滚动',
        label: 'scroll-x',
        kind: 9
      },
      {
        insertText: 'scroll-y',
        documentation: '允许竖向滚动',
        label: 'scroll-y',
        kind: 9
      },
      {
        insertText: 'upper-threshold="{{Number}}"',
        documentation: '距顶部/左边多远时（单位px），触发 scrolltoupper 事件',
        label: 'upper-threshold',
        kind: 9
      },
      {
        insertText: 'lower-threshold="{{Number}}"',
        documentation: '距底部/右边多远时（单位px），触发 scrolltolower 事件',
        label: 'lower-threshold',
        kind: 9
      },
      {
        insertText: 'scroll-top="{{Number}}"',
        documentation: '设置竖向滚动条位置',
        label: 'scroll-top',
        kind: 9
      },
      {
        insertText: 'scroll-left="{{Number}}"',
        documentation: '设置横向滚动条位置',
        label: 'scroll-left',
        kind: 9
      },
      {
        insertText: 'scroll-into-view="{{String}}"',
        documentation:
          '值应为某子元素id，则滚动到该元素，元素顶部对齐滚动区域顶部',
        label: 'scroll-into-view',
        kind: 9
      },
      {
        insertText: 'scroll-with-animation',
        documentation: '在设置滚动条位置时使用动画过渡',
        label: 'scroll-with-animation',
        kind: 9
      },
      {
        insertText: 'enable-back-to-top',
        documentation:
          'iOS点击顶部状态栏、安卓双击标题栏时，滚动条返回顶部，只支持竖向',
        label: 'enable-back-to-top',
        kind: 9
      },
      {
        insertText: 'bindscrolltoupper="{{EventHandle}}"',
        documentation: '滚动到顶部/左边，会触发 scrolltoupper 事件',
        label: 'bindscrolltoupper',
        kind: 9
      },
      {
        insertText: 'bindscrolltolower="{{EventHandle}}"',
        documentation: '滚动到底部/右边，会触发 scrolltolower 事件',
        label: 'bindscrolltolower',
        kind: 9
      },
      {
        insertText: 'bindscroll="{{EventHandle}}"',
        documentation: '滚动时触发',
        label: 'bindscroll',
        kind: 9
      }
    ],
    'share-button': [
      {
        insertText: 'size="{{36}}"',
        documentation: '尺寸',
        label: 'size',
        kind: 9
      },
      {
        insertText: 'type="{{default-dark}}"',
        documentation: '类型',
        label: 'type',
        kind: 9
      },
      {
        insertText: 'bindshare="{{EventHandle}}"',
        documentation: '开始分享事件',
        label: 'bindshare',
        kind: 9
      },
      {
        insertText: 'bindsuccess="{{EventHandle}}"',
        documentation: '分享成功事件',
        label: 'bindsuccess',
        kind: 9
      },
      {
        insertText: 'bindcancel="{{EventHandle}}"',
        documentation: '取消分享事件',
        label: 'bindcancel',
        kind: 9
      }
    ],
    slider: [
      {
        insertText: 'min="{{0}}"',
        documentation: '最小值',
        label: 'min',
        kind: 9
      },
      {
        insertText: 'max="{{100}}"',
        documentation: '最大值',
        label: 'max',
        kind: 9
      },
      {
        insertText: 'step="{{1}}"',
        documentation: '步长',
        label: 'step',
        kind: 9
      },
      {
        insertText: 'disabled',
        documentation: '是否禁用',
        label: 'disabled',
        kind: 9
      },
      {
        insertText: 'value="{{0}}"',
        documentation: '当前取值',
        label: 'value',
        kind: 9
      },
      {
        insertText: 'show-value',
        documentation: '是否显示当前取值',
        label: 'show-value',
        kind: 9
      },
      {
        insertText: 'bindchange="{{EventHandle}}"',
        documentation: '完成一次拖动后触发的事件',
        label: 'bindchange',
        kind: 9
      },
      {
        insertText: 'color="{{}}"',
        documentation: '背景条的颜色',
        label: 'color',
        kind: 9
      },
      {
        insertText: 'selected-color="{{}}"',
        documentation: '已选择的颜色',
        label: 'selected-color',
        kind: 9
      }
    ],
    swiper: [
      {
        insertText: 'autoplay',
        documentation: '是否自动切换',
        label: 'autoplay',
        kind: 9
      },
      {
        insertText: 'indicator-dots',
        documentation: '是否显示面板指示点',
        label: 'indicator-dots',
        kind: 9
      },
      {
        insertText: 'current="{{0}}"',
        documentation: '当前所在页面的 index',
        label: 'current',
        kind: 9
      },
      {
        insertText: 'interval="{{5000}}"',
        documentation: '自动切换时间间隔',
        label: 'interval',
        kind: 9
      },
      {
        insertText: 'duration="{{1000}}"',
        documentation: '滑动动画时长',
        label: 'duration',
        kind: 9
      },
      {
        insertText: 'bindchange="{{EventHandle}}"',
        documentation: '所在页面改变时触发的事件',
        label: 'bindchange',
        kind: 9
      },
      {
        insertText: 'circular',
        documentation: '是否采用衔接滑动',
        label: 'circular',
        kind: 9
      }
    ],
    switch: [
      {
        insertText: 'type="{{switch}}"',
        documentation: '类型',
        label: 'type',
        kind: 9
      },
      {
        insertText: 'checked',
        documentation: '是否选中',
        label: 'checked',
        kind: 9
      },
      {
        insertText: 'bindchange="{{EventHandle}}"',
        documentation: '是否选中',
        label: 'bindchange',
        kind: 9
      },
      {
        insertText: 'color="{{color}}"',
        documentation: '颜色',
        label: 'color',
        kind: 9
      }
    ],
    template: [
      {
        insertText: 'name="{{}}"',
        documentation: '模板名字',
        label: 'name',
        kind: 9
      },
      {
        insertText: 'is="{{}}"',
        documentation: '使用的模板的名字',
        label: 'is',
        kind: 9
      },
      {
        insertText: 'data="{{}}"',
        documentation: '使用的模板所需要的数据',
        label: 'data',
        kind: 9
      }
    ],
    text: [
      {
        insertText: 'selectable',
        documentation: '是否可长按选中',
        label: 'selectable',
        kind: 9
      }
    ],
    textarea: [
      {
        insertText: 'maxlength="{{Number}}"',
        documentation: '最大输入长度',
        label: 'maxlength',
        kind: 9
      },
      {
        insertText: 'auto-focus',
        documentation: '自动聚焦',
        label: 'auto-focus',
        kind: 9
      },
      {
        insertText: 'focus="{{Boolean}}"',
        documentation: '设置聚焦',
        label: 'focus',
        kind: 9
      },
      {
        insertText: 'placeholder="{{String}}"',
        documentation: '占位符',
        label: 'placeholder',
        kind: 9
      },
      {
        insertText: 'placeholder-style="{{String}}"',
        documentation: '占位符样式',
        label: 'placeholder-style',
        kind: 9
      },
      {
        insertText: 'placeholder-class="{{String}}"',
        documentation: '占位符样式类',
        label: 'placeholder-class',
        kind: 9
      },
      {
        insertText: 'auto-fill="{{String}}"',
        documentation: '是否开启自动填写',
        label: 'auto-fill',
        kind: 9
      },
      {
        insertText: 'bindlinechange="{{EventHandle}}"',
        documentation: '行数变化时触发',
        label: 'bindlinechange',
        kind: 9
      },
      {
        insertText: 'bindblur="{{EventHandle}}"',
        documentation: '输入框失去焦点时调用',
        label: 'bindblur',
        kind: 9
      },
      {
        insertText: 'bindfocus="{{EventHandle}}"',
        documentation: '输入框聚焦时调用',
        label: 'bindfocus',
        kind: 9
      },
      {
        insertText: 'confirm',
        documentation: '是否显示完成按钮',
        label: 'confirm',
        kind: 9
      },
      {
        insertText: 'disabled',
        documentation: '是否不可用',
        label: 'disabled',
        kind: 9
      },
      {
        insertText: 'hidden',
        documentation: '是否隐藏',
        label: 'hidden',
        kind: 9
      },
      {
        insertText: 'auto-height',
        documentation: '是否自动增高',
        label: 'auto-height',
        kind: 9
      },
      {
        insertText: 'cursor-spacing="{{Number}}"',
        documentation: '光标与键盘之间的间距',
        label: 'cursor-spacing',
        kind: 9
      },
      {
        insertText: 'bindconfirm="{{EventHandle}}"',
        documentation: '键盘点击完成时触发',
        label: 'bindconfirm',
        kind: 9
      },
      {
        insertText: 'fixed',
        documentation: '固定区域',
        label: 'fixed',
        kind: 9
      }
    ],
    video: [
      {
        insertText: 'src="{{src}}"',
        documentation: '视频资源地址',
        label: 'src',
        kind: 9
      },
      {
        insertText: 'controls="{{controls}}"',
        documentation: '是否显示默认控件',
        label: 'controls',
        kind: 9
      },
      {
        insertText: 'danmu-list="{{danmuList}}"',
        documentation: '弹幕列表',
        label: 'danmu-list',
        kind: 9
      },
      {
        insertText: 'danmu-btn="{{false}}"',
        documentation: '是否显示弹幕按钮',
        label: 'danmu-btn',
        kind: 9
      },
      {
        insertText: 'danmu-btn="{{false}}"',
        documentation: '是否默认显示弹幕',
        label: 'enable-danmu',
        kind: 9
      },
      {
        insertText: 'autoplay="{{false}}"',
        documentation: '是否自动播放',
        label: 'autoplay',
        kind: 9
      },
      {
        insertText: 'bindplay="{{EventHandle}}"',
        documentation: '视频开始播放事件',
        label: 'bindplay',
        kind: 9
      },
      {
        insertText: 'bindpause="{{EventHandle}}"',
        documentation: '视频暂停播放事件',
        label: 'bindpause',
        kind: 9
      },
      {
        insertText: 'bindeneded="{{EventHandle}}"',
        documentation: '视频播放结束事件',
        label: 'bindended',
        kind: 9
      },
      {
        insertText: 'binderror="{{EventHandle}}"',
        documentation: '视频错误事件',
        label: 'binderror',
        kind: 9
      },
      {
        insertText: 'bindtimeupdate="{{EventHandle}}"',
        documentation: '播放进度变化时触发',
        label: 'bindtimeupdate',
        kind: 9
      },
      {
        insertText: 'objectFit="{{String}}"',
        documentation: '当视频大小与 video 容器大小不一致时，视频的表现形式',
        label: 'objectFit',
        kind: 9
      }
    ],
    view: [
      {
        insertText: 'hover-class="{{className}}"',
        documentation: '指定按下去的样式类',
        label: 'hover-class',
        kind: 9
      },
      {
        insertText: 'hover-start-time="{{Number}}"',
        documentation: '按住后多久出现点击态',
        label: 'hover-start-time',
        kind: 9
      },
      {
        insertText: 'hover-stay-time="{{Number}}"',
        documentation: '手指松开后点击态保留时间',
        label: 'hover-stay-time',
        kind: 9
      }
    ]
  },
  VALUE: {
    'audio,loop': [
      {
        insertText: '{{true}}',
        documentation: '循环播放',
        label: '{{true}}',
        kind: 11
      },
      {
        insertText: '{{false}}',
        documentation: '不循环播放',
        label: '{{false}}',
        kind: 11
      }
    ],
    'audio,controls': [
      {
        insertText: '{{true}}',
        documentation: '显示默认控件',
        label: '{{true}}',
        kind: 11
      },
      {
        insertText: '{{false}}',
        documentation: '不显示默认控件',
        label: '{{false}}',
        kind: 11
      }
    ],
    'button,size': [
      {
        insertText: 'default',
        documentation: '默认尺寸',
        label: 'default',
        kind: 11
      },
      { insertText: 'mini', documentation: '迷你尺寸', label: 'mini', kind: 11 }
    ],
    'button,type': [
      {
        insertText: 'primary',
        documentation: '基本',
        label: 'primary',
        kind: 11
      },
      {
        insertText: 'default',
        documentation: '默认',
        label: 'default',
        kind: 11
      },
      { insertText: 'warn', documentation: '警告', label: 'warn', kind: 11 }
    ],
    'button,form-type': [
      {
        insertText: 'submit',
        documentation: '提交表单',
        label: 'submit',
        kind: 11
      },
      {
        insertText: 'reset',
        documentation: '重置表单',
        label: 'reset',
        kind: 11
      }
    ],
    'button,open-type': [
      {
        insertText: 'contact',
        documentation: '打开客服会话',
        label: 'contact',
        kind: 11
      },
      {
        insertText: 'share',
        documentation: '触发用户转发，使用前建议先阅读使用指引',
        label: 'share',
        kind: 11
      }
    ],
    'contact-button,type': [
      {
        insertText: 'default-dark',
        documentation: '默认深色',
        label: 'default-dark',
        kind: 11
      },
      {
        insertText: 'default-light',
        documentation: '默认浅色',
        label: 'default-light',
        kind: 11
      }
    ],
    'icon,type': [
      {
        insertText: 'success',
        documentation: '成功',
        label: 'success',
        kind: 11
      },
      {
        insertText: 'success_no_circle',
        documentation: '成功（无圆圈）',
        label: 'success_no_circle',
        kind: 11
      },
      {
        insertText: 'info',
        documentation: '提示信息',
        label: 'info',
        kind: 11
      },
      { insertText: 'warn', documentation: '警告', label: 'warn', kind: 11 },
      {
        insertText: 'waiting',
        documentation: '请等待',
        label: 'waiting',
        kind: 11
      },
      {
        insertText: 'cancel',
        documentation: '取消',
        label: 'cancel',
        kind: 11
      },
      {
        insertText: 'download',
        documentation: '下载',
        label: 'download',
        kind: 11
      },
      {
        insertText: 'search',
        documentation: '搜索',
        label: 'search',
        kind: 11
      },
      { insertText: 'clear', documentation: '清空', label: 'clear', kind: 11 }
    ],
    'image,mode': [
      {
        insertText: 'scaleToFill',
        documentation:
          '不保持纵横比缩放图片，使图片的宽高完全拉伸至填满 image 元素',
        label: 'scaleToFill',
        kind: 11
      },
      {
        insertText: 'aspectFit',
        documentation:
          '保持纵横比缩放图片，使图片的长边能完全显示出来。也就是说，可以完整地将图片显示出来。',
        label: 'aspectFit',
        kind: 11
      },
      {
        insertText: 'aspectFill',
        documentation:
          '保持纵横比缩放图片，只保证图片的短边能完全显示出来。也就是说，图片通常只在水平或垂直方向是完整的，另一个方向将会发生截取。',
        label: 'aspectFill',
        kind: 11
      },
      {
        insertText: 'top',
        documentation: '不缩放图片，只显示图片的顶部区域',
        label: 'top',
        kind: 11
      },
      {
        insertText: 'bottom',
        documentation: '不缩放图片，只显示图片的底部区域',
        label: 'bottom',
        kind: 11
      },
      {
        insertText: 'center',
        documentation: '不缩放图片，只显示图片的中间区域',
        label: 'center',
        kind: 11
      },
      {
        insertText: 'left',
        documentation: '不缩放图片，只显示图片的左边区域',
        label: 'left',
        kind: 11
      },
      {
        insertText: 'right',
        documentation: '不缩放图片，只显示图片的右边区域',
        label: 'right',
        kind: 11
      },
      {
        insertText: 'top left',
        documentation: '不缩放图片，只显示图片的左上边区域',
        label: 'top left',
        kind: 11
      },
      {
        insertText: 'top right',
        documentation: '不缩放图片，只显示图片的右上边区域',
        label: 'top right',
        kind: 11
      },
      {
        insertText: 'bottom left',
        documentation: '不缩放图片，只显示图片的左下边区域',
        label: 'bottom left',
        kind: 11
      },
      {
        insertText: 'bottom right',
        documentation: '不缩放图片，只显示图片的右下边区域',
        label: 'bottom right',
        kind: 11
      },
      {
        insertText: 'widthFix',
        documentation: '高度会自动根据宽度变化来变化，保持长宽比不变',
        label: 'widthFix',
        kind: 11
      }
    ],
    'input,type': [
      {
        insertText: 'text',
        documentation: '文本输入框',
        label: 'text',
        kind: 11
      },
      {
        insertText: 'number',
        documentation: '数字输入框',
        label: 'number',
        kind: 11
      },
      {
        insertText: 'digit',
        documentation: '带小数点的数字输入框',
        label: 'digit',
        kind: 11
      },
      {
        insertText: 'idcard',
        documentation: '身份证类型的输入框',
        label: 'idcard',
        kind: 11
      }
    ],
    'navigator,open-type': [
      {
        insertText: 'redirect',
        documentation: '关闭当前页面',
        label: 'redirect',
        kind: 11
      },
      {
        insertText: 'navigate',
        documentation: '打开新页面',
        label: 'navigate',
        kind: 11
      },
      {
        insertText: 'switchTab',
        documentation: '跳转到 tabBar 页面',
        label: 'switchTab',
        kind: 11
      },
      {
        insertText: 'reLaunch',
        documentation: '打开新页面，并关闭之前所有页面',
        label: 'reLaunch',
        kind: 11
      },
      {
        insertText: 'navigateBack',
        documentation: '回退页面',
        label: 'navigateBack',
        kind: 11
      }
    ],
    'picker,mode': [
      {
        insertText: 'selector',
        documentation: '单项选择器',
        label: 'selector',
        kind: 11
      },
      {
        insertText: 'time',
        documentation: '时间选择器',
        label: 'time',
        kind: 11
      },
      {
        insertText: 'date',
        documentation: '日期选择器',
        label: 'date',
        kind: 11
      }
    ],
    'picker,fields': [
      {
        insertText: 'day',
        documentation: '可以选择年、月、日',
        label: 'day',
        kind: 11
      },
      {
        insertText: 'month',
        documentation: '可以选择年、月',
        label: 'month',
        kind: 11
      },
      {
        insertText: 'year',
        documentation: '可以选择年',
        label: 'year',
        kind: 11
      }
    ],
    'share-button,type': [
      {
        insertText: 'default-dark',
        documentation: '默认深色',
        label: 'default-dark',
        kind: 11
      },
      {
        insertText: 'default-light',
        documentation: '默认浅色',
        label: 'default-light',
        kind: 11
      }
    ],
    'switch,type': [
      {
        insertText: 'switch',
        documentation: '开关式',
        label: 'switch',
        kind: 11
      },
      {
        insertText: 'checkbox',
        documentation: '勾选式',
        label: 'checkbox',
        kind: 11
      }
    ],
    'video,controls': [
      {
        insertText: '{{true}}',
        documentation: '显示默认控件',
        label: '{{true}}',
        kind: 11
      },
      {
        insertText: '{{false}}',
        documentation: '不显示默认控件',
        label: '{{false}}',
        kind: 11
      }
    ],
    'video,danmu-btn': [
      {
        insertText: '{{true}}',
        documentation: '显示弹幕按钮',
        label: '{{true}}',
        kind: 11
      },
      {
        insertText: '{{false}}',
        documentation: '不显示弹幕按钮',
        label: '{{false}}',
        kind: 11
      }
    ],
    'video,enable-danmu': [
      {
        insertText: '{{true}}',
        documentation: '默认显示弹幕',
        label: '{{true}}',
        kind: 11
      },
      {
        insertText: '{{false}}',
        documentation: '默认不显示弹幕',
        label: '{{false}}',
        kind: 11
      }
    ],
    'video,autoplay': [
      {
        insertText: '{{true}}',
        documentation: '自动播放',
        label: '{{true}}',
        kind: 11
      },
      {
        insertText: '{{false}}',
        documentation: '不自动播放',
        label: '{{false}}',
        kind: 11
      }
    ],
    'video,objectFit': [
      {
        insertText: 'contain',
        documentation: '包含',
        label: 'contain',
        kind: 11
      },
      { insertText: 'fill', documentation: '填充', label: 'fill', kind: 11 },
      { insertText: 'cover', documentation: '覆盖', label: 'cover', kind: 11 }
    ]
  },
  TAG: [
    {
      insertText: '<audio src="{{src}}">{{}}</audio>',
      documentation: '音频',
      label: 'audio',
      kind: 13
    },
    {
      insertText: '<button>{{}}</button>',
      documentation: '按钮',
      label: 'button',
      kind: 13
    },
    {
      insertText: '<canvas {{}} />',
      documentation: '画布',
      label: 'canvas',
      kind: 13
    },
    {
      insertText: '<checkbox-group>{{}}</checkbox-group>',
      documentation: '多项选择器',
      label: 'checkbox-group',
      kind: 13
    },
    {
      insertText: '<checkbox value="{{value}}" checked="{{false}}" />',
      documentation: '多选项目',
      label: 'checkbox',
      kind: 13
    },
    {
      insertText: '<contact-button></contact-button>',
      documentation: '客服会话按钮',
      label: 'contact-button',
      kind: 13
    },
    {
      insertText: '<form>{{}}</form>',
      documentation: '表单',
      label: 'form',
      kind: 13
    },
    {
      insertText: '<icon type="{{String}}" />',
      documentation: '图标',
      label: 'icon',
      kind: 13
    },
    {
      insertText: '<image src="{{src}}"></image>',
      documentation: '图片',
      label: 'image',
      kind: 13
    },
    {
      insertText: '<input {{}} />',
      documentation: '输入框',
      label: 'input',
      kind: 13
    },
    {
      insertText: '<label>{{}}</label>',
      documentation: '标签',
      label: 'label',
      kind: 13
    },
    {
      insertText: '<map {{}}/>',
      documentation: '地图',
      label: 'map',
      kind: 13
    },
    {
      insertText: '<navigator url="{{url}}">{{}}</navigator>',
      documentation: '页面链接',
      label: 'navigator',
      kind: 13
    },
    {
      insertText: '<picker-view-column>{{}}</picker-view-column>',
      documentation: '内嵌选择器项',
      label: 'picker-view-column',
      kind: 13
    },
    {
      insertText: '<picker-view>{{}}</picker-view>',
      documentation: '内嵌选择器',
      label: 'picker-view',
      kind: 13
    },
    {
      insertText: '<picker>{{}}</picker>',
      documentation: '选择器',
      label: 'picker',
      kind: 13
    },
    {
      insertText: '<progress />',
      documentation: '地图',
      label: 'progress',
      kind: 13
    },
    {
      insertText: '<radio-group>{{}}</radio-group>',
      documentation: '单项选择器',
      label: 'radio-group',
      kind: 13
    },
    {
      insertText: '<radio value="{{value}}" checked="{{false}}" />',
      documentation: '单选项目',
      label: 'radio',
      kind: 13
    },
    {
      insertText: '<scroll-view>{{}}</scroll-view>',
      documentation: '可滚动视图区域',
      label: 'scroll-view',
      kind: 13
    },
    {
      insertText: '<share-button></share-button>',
      documentation: '分享按钮',
      label: 'share-button',
      kind: 13
    },
    {
      insertText: '<slider />',
      documentation: '滑动选择器',
      label: 'slider',
      kind: 13
    },
    {
      insertText: '<swiper-item>{{}}</swiper-item>',
      documentation: '滑块视图项目',
      label: 'swiper-item',
      kind: 13
    },
    {
      insertText: '<swiper>{{}}</swiper>',
      documentation: '滑块视图',
      label: 'swiper',
      kind: 13
    },
    {
      insertText: '<switch type="{{switch}}" />',
      documentation: '开关选择器',
      label: 'switch',
      kind: 13
    },
    {
      insertText: '<template {{}}></template>',
      documentation: '模板',
      label: 'template',
      kind: 13
    },
    {
      insertText: '<text>{{}}</text>',
      documentation: '文本',
      label: 'text',
      kind: 13
    },
    {
      insertText: '<textarea {{}} />',
      documentation: '多行输入框',
      label: 'textarea',
      kind: 13
    },
    {
      insertText: '<video src="{{src}}" {{}}></video>',
      documentation: '视频',
      label: 'video',
      kind: 13
    },
    {
      insertText: '<view class="{{classname}}">{{}}</view>',
      documentation: '视图窗口',
      label: 'view',
      kind: 13
    }
  ],
  TAGSWITHOUTLT: [
    {
      insertText: 'audio src="{{src}}">{{}}</audio>',
      documentation: '音频',
      label: 'audio',
      kind: 13
    },
    {
      insertText: 'button>{{}}</button>',
      documentation: '按钮',
      label: 'button',
      kind: 13
    },
    {
      insertText: 'canvas {{}} />',
      documentation: '画布',
      label: 'canvas',
      kind: 13
    },
    {
      insertText: 'checkbox-group>{{}}</checkbox-group>',
      documentation: '多项选择器',
      label: 'checkbox-group',
      kind: 13
    },
    {
      insertText: 'checkbox value="{{value}}" checked="{{false}}" />',
      documentation: '多选项目',
      label: 'checkbox',
      kind: 13
    },
    {
      insertText: 'contact-button></contact-button>',
      documentation: '客服会话按钮',
      label: 'contact-button',
      kind: 13
    },
    {
      insertText: 'form>{{}}</form>',
      documentation: '表单',
      label: 'form',
      kind: 13
    },
    {
      insertText: 'icon type="{{String}}" />',
      documentation: '图标',
      label: 'icon',
      kind: 13
    },
    {
      insertText: 'image src="{{src}}"></image>',
      documentation: '图片',
      label: 'image',
      kind: 13
    },
    {
      insertText: 'input {{}} />',
      documentation: '输入框',
      label: 'input',
      kind: 13
    },
    {
      insertText: 'label>{{}}</label>',
      documentation: '标签',
      label: 'label',
      kind: 13
    },
    { insertText: 'map {{}}/>', documentation: '地图', label: 'map', kind: 13 },
    {
      insertText: 'navigator url="{{url}}">{{}}</navigator>',
      documentation: '页面链接',
      label: 'navigator',
      kind: 13
    },
    {
      insertText: 'picker-view-column>{{}}</picker-view-column>',
      documentation: '内嵌选择器项',
      label: 'picker-view-column',
      kind: 13
    },
    {
      insertText: 'picker-view>{{}}</picker-view>',
      documentation: '内嵌选择器',
      label: 'picker-view',
      kind: 13
    },
    {
      insertText: 'picker>{{}}</picker>',
      documentation: '选择器',
      label: 'picker',
      kind: 13
    },
    {
      insertText: 'progress />',
      documentation: '地图',
      label: 'progress',
      kind: 13
    },
    {
      insertText: 'radio-group>{{}}</radio-group>',
      documentation: '单项选择器',
      label: 'radio-group',
      kind: 13
    },
    {
      insertText: 'radio value="{{value}}" checked="{{false}}" />',
      documentation: '单选项目',
      label: 'radio',
      kind: 13
    },
    {
      insertText: 'scroll-view>{{}}</scroll-view>',
      documentation: '可滚动视图区域',
      label: 'scroll-view',
      kind: 13
    },
    {
      insertText: 'share-button></share-button>',
      documentation: '分享按钮',
      label: 'share-button',
      kind: 13
    },
    {
      insertText: 'slider />',
      documentation: '滑动选择器',
      label: 'slider',
      kind: 13
    },
    {
      insertText: 'swiper-item>{{}}</swiper-item>',
      documentation: '滑块视图项目',
      label: 'swiper-item',
      kind: 13
    },
    {
      insertText: 'swiper>{{}}</swiper>',
      documentation: '滑块视图',
      label: 'swiper',
      kind: 13
    },
    {
      insertText: 'switch type="{{switch}}" />',
      documentation: '开关选择器',
      label: 'switch',
      kind: 13
    },
    {
      insertText: 'template {{}}></template>',
      documentation: '模板',
      label: 'template',
      kind: 13
    },
    {
      insertText: 'text>{{}}</text>',
      documentation: '文本',
      label: 'text',
      kind: 13
    },
    {
      insertText: 'textarea {{}} />',
      documentation: '多行输入框',
      label: 'textarea',
      kind: 13
    },
    {
      insertText: 'video src="{{src}}" {{}}></video>',
      documentation: '视频',
      label: 'video',
      kind: 13
    },
    {
      insertText: 'view class="{{classname}}">{{}}</view>',
      documentation: '视图窗口',
      label: 'view',
      kind: 13
    }
  ],
  UNIVERSAL_ATTRIBUTE_NAMES: [
    {
      insertText: 'bindtap="{{}}"',
      documentation: 'tap事件绑定，不阻止冒泡',
      label: 'bindtap',
      kind: 9
    },
    {
      insertText: 'catchtap="{{}}"',
      documentation: 'tap事件绑定，阻止冒泡',
      label: 'catchtap',
      kind: 9
    },
    {
      insertText: 'bindlongtap="{{}}"',
      documentation: 'longtap事件绑定，不阻止冒泡',
      label: 'bindlongtap',
      kind: 9
    },
    {
      insertText: 'catchlongtap="{{}}"',
      documentation: 'longtap事件绑定，阻止冒泡',
      label: 'catchlongtap',
      kind: 9
    },
    {
      insertText: 'bindtouchstart="{{}}"',
      documentation: 'touchstart事件绑定，不阻止冒泡',
      label: 'bindtouchstart',
      kind: 9
    },
    {
      insertText: 'catchtouchstart="{{}}"',
      documentation: 'touchstart事件绑定，阻止冒泡',
      label: 'catchtouchstart',
      kind: 9
    },
    {
      insertText: 'bindtouchmove="{{}}"',
      documentation: 'touchmove事件绑定，不阻止冒泡',
      label: 'bindtouchmove',
      kind: 9
    },
    {
      insertText: 'catchtouchmove="{{}}"',
      documentation: 'touchmove事件绑定，阻止冒泡',
      label: 'catchtouchmove',
      kind: 9
    },
    {
      insertText: 'bindtouchend="{{}}"',
      documentation: 'touchend事件绑定，不阻止冒泡',
      label: 'bindtouchend',
      kind: 9
    },
    {
      insertText: 'catchtouchend="{{}}"',
      documentation: 'touchend事件绑定，阻止冒泡',
      label: 'catchtouchend',
      kind: 9
    },
    {
      insertText: 'bindtouchcancel="{{}}"',
      documentation: 'touchcancel事件绑定，不阻止冒泡',
      label: 'bindtouchcancel',
      kind: 9
    },
    {
      insertText: 'catchtouchcancel="{{}}"',
      documentation: 'touchcancel事件绑定，阻止冒泡',
      label: 'catchtouchcancel',
      kind: 9
    },
    {
      insertText: 'wx:for="{{}}"',
      documentation: '重复渲染',
      label: 'wx:for',
      kind: 9
    },
    {
      insertText: 'wx:if="{{}}"',
      documentation: '条件渲染，如果为真时渲染',
      label: 'wx:if',
      kind: 9
    },
    {
      insertText: 'wx:key="{{}}"',
      documentation: '列表中item的唯一标识符',
      label: 'wx:key',
      kind: 9
    },
    {
      insertText: 'hidden="{{}}"',
      documentation: '是否隐藏',
      label: 'hidden',
      kind: 9
    },
    {
      insertText: 'data-{{name}}="{{value}}"',
      documentation: '自定义数据',
      label: 'data-',
      kind: 9
    },
    { insertText: 'id="{{}}"', documentation: 'ID', label: 'id', kind: 9 },
    {
      insertText: 'class="{{}}"',
      documentation: 'css类',
      label: 'class',
      kind: 9
    },
    {
      insertText: 'style="{{}}"',
      documentation: 'style样式',
      label: 'style',
      kind: 9
    }
  ],
  UNIVERSAL_ATTRIBUTE_VALUES: {}
}
