const log = require('./logger.js')
async function setChromeProxy(config) {
  return new Promise((resolve, reject) => {
    chrome.proxy.settings.set(
      {
        value: config,
        scope: 'regular'
      },
      () => {
        log.info(`setChromeProxy config: ${JSON.stringify(config)}`)
        resolve()
      }
    )
  })
}

module.exports = setChromeProxy
