class RoomScene extends egret.Sprite {

  private startLabel: egret.TextField
  private players: Array<any>

  public constructor() {
    super();
    this.init()
  }

  // 初始化(给开始按钮绑定点击事件)
  private init() {
    console.log('RoomScene.init')
    this.initBg()
    this.initStartLabel()

    this.addChild(this.startLabel);
    // put display object to this scene
  }

  public update(data) {
    const payload = data.payload
    if(payload.seat == 0) {
      this.startLabel.text = '开始'
      this.startLabel.touchEnabled = true
      this.startLabel.addEventListener(egret.TouchEvent.TOUCH_TAP, this.startHandler, this)
    }
  }

  private initBg() {
    var shape: egret.Shape = new egret.Shape();
    shape.graphics.beginFill(0x343E5F);
    shape.graphics.drawRect(0, 0, 2000, 2000);
    shape.graphics.endFill();
    this.addChild(shape);
    var bg: egret.Bitmap = new egret.Bitmap()
    bg.texture = RES.getRes("logo_jpg")
    bg.scaleX = bg.scaleY = 2
    bg.x = 1334 / 2 - 280
    bg.y = 100
    this.addChild(bg)
  }
  private initStartLabel() {
    this.startLabel = new egret.TextField()
    this.startLabel.textColor = 0xF0D66D
    this.startLabel.text = "请稍等..."
    this.startLabel.width = 200
    this.startLabel.anchorOffsetX = 100
    this.startLabel.x = 1334 / 2
    this.startLabel.textAlign = egret.HorizontalAlign.CENTER;
    this.startLabel.y = 1136 / 2
  }

  private startHandler() {
    console.log('starthandler')
    SceneManager.getInstance().changeScene('gameScene');
  }

  public release() {
    // 移除事件
  }
}