import React from "react";
import ReactDOM from "react-dom";

import { AppContainer } from "react-hot-loader";
// AppContainer 是一个 HMR 必须的包裹(wrapper)组件

import App from "./views/App";

const render = (Component) => {
    ReactDOM.render(
        <AppContainer>
            <Component/>
        </AppContainer>,
        document.getElementById("root")
    );
};

render(App);

// 模块热替换的 API
if (module.hot) {
    module.hot.accept("./views/App", () => {
        render(App)
    });
}

// npm install --save-dev webpack webpack-dev-server
// npm install --save-dev babel-core babel-loader babel-preset-es2015 babel-preset-react
// npm install --save-dev style-loader css-loader
// npm install --save react react-dom react-hot-loader@next
