import React, {Component} from 'react'
import T from 'prop-types'

import '../assets/index.less'

class Rate extends Component {
  constructor(props) {
    super(props)
    const {defaultValue = 0, value = 0, total = 5, disabled = false} = props
    this.state = {
      value: value || defaultValue,
      currentValue: value || defaultValue,
      total: total,
      disabled: disabled
    }
  }

  componentWillReceiveProps(props) {
    const {value} = props
    this.setState({value: value})
  }

  render() {
    const {className = ""} = this.props,
      {value, currentValue, total, disabled} = this.state,
      rates = []

    rates.push(<li key="text" className={"wea-r-item " + (currentValue ? "wea-r-text-hover" : "wea-r-text")}>{currentValue}分</li>)
    if (disabled) {
      for (let i = 0; i < total; i++) {
        if (i < currentValue) {
          rates.push(
            <li key={i} className="wea-r-item wea-r-score wea-r-score-selected icon-blog-Score"/>
          )
        } else {
          rates.push(
            <li key={i} className="wea-r-item wea-r-score icon-blog-Score-o"/>
          )
        }
      }
      return <ul className={"wea-rate " + className} >{rates}</ul>
    } else {
      for (let i = 0; i < total; i++) {
        if (i < currentValue) {
          rates.push(
            <li
              key={i}
              value={i + 1}
              className="wea-r-item wea-r-score-hover wea-r-score-selected icon-blog-Score"
              onMouseEnter={this.onMouseEnter}
              onMouseLeave={this.onMouseLeave}
            />
          )
        } else {
          rates.push(
            <li
              key={i}
              value={i + 1}
              className="wea-r-item wea-r-score-hover icon-blog-Score-o"
              onMouseEnter={this.onMouseEnter}
              onMouseLeave={this.onMouseLeave}
            />
          )
        }
      }
      return (
        <ul className={"wea-rate " + className} onClick={this.onClick}>
          {rates}
        </ul>
      )
    }
  }

  onClick = (e) => {
    const {onChange} = this.props
    if (onChange) onChange(e.target.value)
  }

  onMouseEnter = (e) => {
    this.setState({currentValue: e.target.value})
  }

  onMouseLeave = (e) => {
    this.setState({currentValue: this.state.value})
  }
}

Rate.propTypes = {
  value: T.number.isRequired,
  onChange: T.func.isRequired,
  disabled: T.bool,
  total: T.number,
  defaultValue: T.number
}

Rate.defaultProps = {
  value: 0,
  disabled: false,
  total: 5,
  defaultValue: 0
}

export default Rate
