const async = require('async');
const fs = require('fs');
const CryptoJS = require('crypto-js');

const Sources = require("webpack-sources");
const {ConcatSource} = Sources

class HelloPlugin {
  constructor(options) {
    this.options = options || {};
  }

  apply(compiler) {
    const {passphrase} = this.options

    compiler.plugin("compilation", (compilation) => {
      compilation.plugin("optimize-assets", (assets, callback) => {
        let pattern = /[^\s]*\.js$/;
      
        async.forEach(Object.keys(assets), (file, cb) => {
          const asset = assets[file];

          const unencrypted = asset.source().toString(),
          encrypted = CryptoJS.AES.encrypt(unencrypted, passphrase),
          hmac = CryptoJS.HmacSHA256(encrypted.toString(), CryptoJS.SHA256(passphrase)).toString(),
          encryptedMsg = hmac + encrypted;


          let ciphertext = `
            function test(){ 
              var passphrase = prompt("请输入密码", "");
              let content = "${encryptedMsg}";

              encryptedHMAC = content.substring(0, 64),
              encryptedHTML = content.substring(64),
              decryptedHMAC = CryptoJS.HmacSHA256(encryptedHTML, CryptoJS.SHA256(passphrase)).toString()
  
              if (decryptedHMAC !== encryptedHMAC) {
                alert('Bad passphrase !')
                return
              }

              const plainHTML = CryptoJS.AES.decrypt(encryptedHTML, passphrase).toString(CryptoJS.enc.Utf8);
              eval(plainHTML);
            }
            var flag = false;
            var script = document.createElement('script');
            script.src = 'https://cdn.bootcss.com/jquery/3.2.1/jquery.min.js';
            script.addEventListener("load",function(){
              flag ? test() : flag = true;
            })
            document.body.appendChild(script);
            var script1 = document.createElement('script');
            script1.src = 'https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/crypto-js.min.js';
            document.body.appendChild(script1);
            script1.addEventListener("load",function(){
              flag ? test() : flag = true;
            })
            `
          assets[file] = new ConcatSource(ciphertext);
        
          cb();
        }, callback);
      });
    });
  }
}

module.exports = HelloPlugin;
