import { JSDOM } from 'jsdom';


export const HOST = process.env.BOBCAT_HOST!;

const cookie = process.env.BOBCAT_USER_COOKIE!;

const getContentUrl = (siteId: string) => `${HOST}/s/admin/sites/${siteId}/content`


export const fetchSiteData = async (siteId: string) => {

  const url = getContentUrl(siteId)
  const content = await fetch(url, {
    "headers": {
      "accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7",
      "accept-language": "en-US,en;q=0.9",
      "cache-control": "no-cache",
      "pragma": "no-cache",
      "priority": "u=0, i",
      "sec-ch-ua": "\"Chromium\";v=\"131\", \"Not_A Brand\";v=\"24\"",
      "sec-ch-ua-mobile": "?0",
      "sec-ch-ua-platform": "\"macOS\"",
      "sec-fetch-dest": "document",
      "sec-fetch-mode": "navigate",
      "sec-fetch-site": "same-origin",
      "sec-fetch-user": "?1",
      "upgrade-insecure-requests": "1",
      "cookie": cookie,
      "Referer": url,
      "referrerPolicy": "strict-origin-when-cross-origin",
    },
    "body": null,
    "method": "GET"
  }).then(res => res.text()).then(htmlString => {
    const dom = new JSDOM(htmlString);
    const document = dom.window.document;

    const element: any = document.getElementById('site_data_content');


    const formUrl = document.querySelector('form.edit_site_data').action
    const elementContent = element.value || element.textContent || '{}'

    const content = JSON.parse(elementContent)


    return {
      content,
      formUrl,
    }
  })

  return content
}


