// 如果 diff AI site, 是拿所有 AI site 跟非 AI 的英文 site 进行对比
export const diffBaselineId = "27328697";

export const section_selectors = [
    "27328697",
    "27328389",
    "27328392",
    "27328396",
    "27328399",
    "27328401",
    "27328404",
    "27328406",
    "27328408",
    "27328410",
    "27328412",
    "27328414",
    "27328415",
    "27328416",
    "27328417",
    "27328419",
    "27665235",
    "27656391"
]

export const sectionSelectorLanguages: Record<string, string> = {
    "27328697": "EN-NOT-AI",
    "27328389": "DE-NOT-AI",
    "27328392": "ES-NOT-AI",
    "27328396": "PT-NOT-AI",
    "27328399": "FR-NOT-AI",
    "27328401": "IT-NOT-AI",
    "27328404": "JP-NOT-AI",
    "27328406": "ID-NOT-AI",
    "27328408": "NL-NOT-AI",
    "27328410": "FI-NOT-AI",
    "27328412": "SV-NOT-AI",
    "27328414": "CS-NOT-AI",
    "27328415": "RO-NOT-AI",
    "27328416": "CN_ZH-NOT-AI",
    "27328417": "CN_TW-NOT-AI",
    "27328419": "AR-NOT-AI",
    "27665235": "NO-NOT-AI",
    "27656391": "PL-NOT-AI"
}

export const ai_section_selectors = [
    "29279960",
    "29286540",
    "29286613",
    "29286646",
    "29278357",
    "29286780",
    "29278350",
    "29286835",
    "29286857",
    "29279949",
    "29278331",
    "29278319",
    "29278287",
    "29278284",
    "29278371",
    "29279914",
    "29278297",
    "29279930",
    ...(process.env.USE_AI_SELECTORS ? [diffBaselineId] : [])
]

export const aiSectionSelectorsLanguages: Record<string, string> = {
    "29279960": "EN-AI",
    "29286540": "DE-AI",
    "29286613": "ES-AI",
    "29286646": "PT-AI",
    "29278357": "FR-AI",
    "29286780": "IT-AI",
    "29278350": "JP-AI",
    "29286835": "ID-AI",
    "29286857": "NL-AI",
    "29279949": "FI-AI",
    "29278331": "SV-AI",
    "29278319": "CS-AI",
    "29278287": "RO-AI",
    "29278284": "CN_ZH-AI",
    "29278371": "CN_TW-AI",
    "29279914": "AR-AI",
    "29278297": "NO-AI",
    "29279930": "PL-AI",
    ...(process.env.USE_AI_SELECTORS ? { [diffBaselineId]: sectionSelectorLanguages[diffBaselineId] } : {})
}