# falcon

<!-- Remote Repository URL -->
[Repository URL](https://cd.i.strikingly.com/walter.huang/Falcon)

To install dependencies:

```bash
bun install
```

To run:

```bash
bun run index.ts
```

This project was created using `bun init` in bun v1.1.18. [Bun](https://bun.sh) is a fast all-in-one JavaScript runtime.

## AWS S3 配置

使用 S3 文件上传功能，需要设置以下环境变量：

```bash
AWS_REGION=ap-northeast-1
AWS_ACCESS_KEY_ID=your_access_key_id
AWS_SECRET_ACCESS_KEY=your_secret_key
AWS_S3_BUCKET_NAME=your_bucket_name
```

### 使用示例

```typescript
import { uploadFileFromEnv } from './src/clients/s3';

const key = await uploadFileFromEnv(
  '/path/to/local/file.pdf',
  'uploads/file.pdf',
  { contentType: 'application/pdf', acl: 'private' }
);
```
