import { generateChatCompletions } from "./requestOpenAI";

Bun.serve({
  port: 3000,
  async fetch(req) {
    const url = new URL(req.url);

    // 处理 OPTIONS 预检请求
    if (req.method === "OPTIONS") {
      return new Response(null, {
        status: 204, // No Content
        headers: {
          "Access-Control-Allow-Origin": "*",
          "Access-Control-Allow-Methods": "GET, POST, OPTIONS",
          "Access-Control-Allow-Headers": "Content-Type",
          "Access-Control-Max-Age": "86400",
        },
      });
    }

    // 处理实际请求
    if (url.pathname === "/api/data" && req.method === "POST") {
      try {
        const body = await req.json();

        const { prompt, executeTimes, params } = body;
        const data = await generateChatCompletions(
          prompt,
          executeTimes,
          params
        );

        return new Response(JSON.stringify({ data }), {
          headers: {
            "Content-Type": "application/json",
            "Access-Control-Allow-Origin": "*",
          },
        });
      } catch (error) {
        console.error("Error generating chat completions:", error);
        return new Response("Internal Server Error", { status: 500 });
      }
    }

    return new Response("Hello from Bun server!", {
      headers: {
        "Access-Control-Allow-Origin": "*",
      },
    });
  },
});
